/*
 * BaixaClient.java
 *
 * Created on 9 de junio de 2008, 16:48
 */

package actions;

import entitats.Client;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author dai
 * @version
 */

public class BaixaClient extends Action {
    
    DataSource ds = null;
    Connection con = null;
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        Client client = (Client) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            PreparedStatement sentencia = null;
            ResultSet rs = null;
            
            //Agafem l'id del client
            /*rs = st.executeQuery("SELECT * FROM clients WHERE id = '"+client.getIdClient()+"'");
            rs.next();
            client.setIdClient(rs.getInt("id"));*/
            
            if (client.getIdClient() == 0)
            {
                client.setError("<font color='red'>Has d'escollir un client</font>");
                return mapping.findForward("ok");
            }
            
            //Si un agent vol donar de baixa un propietari
            if (request.getSession().getAttribute("usuariagent") != null) {
                //Comprova que no tingui locals en propietat actualment
                rs = st.executeQuery("SELECT COUNT(*) FROM locals WHERE id_propietari = "+client.getIdClient());
                rs.next();
                if (rs.getInt(1) > 0)
                    client.setError("<font color='red'>No es pot eliminar el propietari degut que te locals donats d'alta encara</font>");
                //El dona de baixa com a propietari
                else {
                    st.executeUpdate("UPDATE clients SET es_propietari = 0 WHERE id = "+ client.getIdClient());
                    client.setError("<font color='blue'>El propietari ha sigut donat de baixa</font>");
                }
            }
            
            //Si un venedor vol donar de baixa un llogater
            if (request.getSession().getAttribute("usuarivenedor") != null) {
                //Comprova que no tingui locals llogats actualment
                rs = st.executeQuery("SELECT COUNT(*) FROM contractes WHERE id_client = "+client.getIdClient());
                rs.next();
                if (rs.getInt(1) > 0)
                    client.setError("<font color='red'>No es pot eliminar el propietari degut que te locals donats d'alta encara</font>");
                //El dona de baixa com a llogater
                else {
                    st.executeUpdate("UPDATE clients SET es_llogater = 0 WHERE id = "+ client.getIdClient());
                    client.setError("<font color='blue'>El llogater ha sigut donat de baixa</font>");
                }
            }
            
            //Comprova si el client encara te rol de propietari o llogater, sino l'elimina definitivament
            rs = st.executeQuery("SELECT es_propietari, es_llogater FROM clients WHERE id = "+ client.getIdClient());
            rs.next();
            if (rs.getBoolean("es_propietari") == false && rs.getBoolean("es_llogater") == false)
            {
                st.executeUpdate("DELETE FROM clients WHERE id = "+ client.getIdClient());
                client.setError(client.getError()+"<br><font color='blue'>Tamb ha sigut donat de baixa de la base de dades</font>");
            }
            
        }catch(Exception excepcio){
            client.setError("<font color='red'>Excepcio ocorreguda en actions.BaixaClient:<br>" +
                    ""+excepcio.getMessage()+"</font>");
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                client.setError("<font color='red'>Excepcio ocorreguda en actions.BaixaClient:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}